<?

/************************************************************************/
/* NUKEDONWLOAD                                                         */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2002 by Courtois Olivier (webmaster@nukedownload.com)  */
/* http://www.nukedownload.com                                          */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// CONSTANTES
$CST_TUTORIALADD="addTutorial";
$CST_TUTORIALEDIT="editTutorial";
$CST_TUTORIAL_INSERT_DB="insertTutorial";
$CST_TUTORIAL_UPDATE_DB="updateTutorial";
$CST_TUTORIAL_DELETE="deleteTutorial";
$CST_TUTORIAL_DELETE_YES="deleteTutorialYes";


/*********************************************************/
/*                                                       */
/*                                                       */
/*              Class ND_RowTutorialAdmin                */
/*                                                       */
/*                                                       */
/*********************************************************/


class ND_RowTutorialAdmin extends ND_Row {
	
function show() {
	global $CST_TUTORIALEDIT,$CST_TUTORIAL_DELETE;
	echo "<TR>";
	echo "<TD>";
	$this->fields["url"]->show();
	echo "<BR>";
	echo $this->value["description"];
	echo "<TD><CENTER>";
	echo "[ <A HREF=\"admin.php?op=$CST_TUTORIALEDIT&tid=".$this->value["tid"]."\">"._EDIT."</A> ] [ <A HREF=\"admin.php?op=$CST_TUTORIAL_DELETE&tid=".$this->value["tid"]."\">"._DELETE."<A> ]";
	echo "</CENTER></TD>";
	echo "</TR>\n";
}
}

/*********************************************************/
/*                                                       */
/*                                                       */
/*              Class ND_RowTutorialAdmin                */
/*                                                       */
/*                                                       */
/*********************************************************/


class ND_RowNewTutorialAdmin extends ND_Row {
	
function show() {
	global $CST_TUTORIALEDIT;
	echo "<TR>";
	echo "<TD>";
	$this->fields["url"]->show();
	echo "<BR>";
	echo $this->value["description"];
	echo "</TD><TD><CENTER>";
	echo $this->fields["categorie"]->show();
	echo "</CENTER></TD><TD><CENTER>";
	echo "[ <A HREF=\"admin.php?op=accept&tid=".$this->value["tid"]."\">Accept</A> ] [ <A HREF=\"admin.php?op=deleteRequest&tid=".$this->value["tid"]."\">"._DELETE."<A> ]";
	echo "</CENTER></TD>";
	echo "</TR>\n";
}
}
/*********************************************************/
/*                                                       */
/*                                                       */
/*              Class ND_TutorialAdmin                   */
/*                                                       */
/*                                                       */
/*********************************************************/


class ND_TutorialAdmin {
	
	var $ADMIN_LINK;               // Link where the page return after an insert, delete or save
	var $TABLE_NAME;


/*********************************************************/
/* setAdminLink                                          */
/*********************************************************/

function  setAdminLink($name) {
	$this->ADMIN_LINK=$name;
}


/*********************************************************/
/* setTableName                                          */
/*********************************************************/

function  setTableName($name) {
	$this->TABLE_NAME=$name;
}

/*********************************************************/
/* ShowAdd                                               */
/*********************************************************/
	
function showAdd() {
	global $prefix, $dbi,$CST_TUTORIAL_INSERT_DB;
	
	$ftitle = new ND_TextField();
	$ftitle->setTitle("Title");
	$ftitle->setColumnName("title");
	$ftitle->setMaxlength(128);
	$fcategorie = new ND_Combo();
	$fcategorie->setDatabase($dbi);
	$fcategorie->setSqlQuery("select cid,categorie from nuke_nd_tutorial_categories");
	$fcategorie->setTitle("Category");
	$furl = new ND_TextField();
	$furl->setTitle("Url");
	$furl->setMaxlength(255);
	$fdescription = new ND_TextArea();
	$fdescription->setTitle("Description");
	
	$rowTutorial = new ND_Row();
   $rowTutorial->setFields(array("title"=>$ftitle,"cid"=>$fcategorie,"url"=>$furl,"description"=>$fdescription));
   $rowTutorial->setAction("admin.php?op=$CST_TUTORIAL_INSERT_DB");
   
   
   $rowTutorial->setActionValue(_ADD);
   echo "<b>Add Tutorial</b>";
   $rowTutorial->edit();  
  
}

/*********************************************************/
/* ShowEdit                                              */
/*********************************************************/

function showEdit() {
	global $prefix, $dbi,$tid,$CST_TUTORIAL_UPDATE_DB;
	
	$ftidLabel = new ND_Label();
	$ftidLabel->setTitle("Tutorial ID");
	$ftid = new ND_TextHidden();
	$ftitle = new ND_TextField();
	$ftitle->setTitle("Title");
	$ftitle->setColumnName("title");
	$ftitle->setMaxlength(128);
	$fcategorie = new ND_Combo();
	$fcategorie->setDatabase($dbi);
	$fcategorie->setSqlQuery("select cid,categorie from nuke_nd_tutorial_categories");
	$fcategorie->setTitle("Category");
	$furl = new ND_TextField();
	$furl->setTitle("Url");
	$furl->setMaxlength(255);
	$fdescription = new ND_TextArea();
	$fdescription->setTitle("Description");
	
	
	$result = sql_query("select tid as tid2,tid,cid,title,description,url,date,hits from nuke_nd_tutorials   where tid=$tid", $dbi);
   $row= mysql_fetch_array($result);
   	
	
	$rowTutorial = new ND_Row();
   $rowTutorial->setFields(array("tid2"=>$ftidLabel,"tid"=>$ftid,"title"=>$ftitle,"cid"=>$fcategorie,"url"=>$furl,"description"=>$fdescription));
   $rowTutorial->setAction("admin.php?op=$CST_TUTORIAL_UPDATE_DB");
   $rowTutorial->setValue($row);
   $rowTutorial->setActionValue(_SAVECHANGES);
   echo "<b>Edit Tutorial</b>";
   $rowTutorial->edit();

}

/*********************************************************/
/* ShowListTutorial                                      */
/*********************************************************/

function ShowListTutorial() {
	global $dbi,$prefix;
	$furl = new ND_LINK();
	$ftitle = new ND_Label();
	$fdescription = new ND_Label();
	
	
	$row = new ND_RowTutorialAdmin();
	$row->setFields(array("url"=>$furl,"title"=>$ftitle,"description"=>$fdescription));
	
	$mytable= new ND_Table();
	$mytable->setName("tutorial");
	$mytable->setSqlQuery("select * from $this->TABLE_NAME order by date desc");
	$mytable->setDatabase($dbi);
	$mytable->setRow($row);
	$mytable->setBorder(1);
	$mytable->setHeader(array("Tutorial","Function"));
		
	$mytable->setHeaderTag("align=\"center\" bgcolor=\"#BFCCDD\"");
	$mytable->setTableTag("WIDTH=\"98%\" BORDER=\"1\"");
	$mytable->show();	
	
}

/*********************************************************/
/* ShowListSubmitTutorial                                */
/*********************************************************/

function ShowListSubmitTutorial() {
	global $dbi,$prefix;
	$furl = new ND_LINK();
	$ftitle = new ND_Label();
	$fdescription = new ND_Label();
	$fcategorie = new ND_Label();
		
	$row = new ND_RowNewTutorialAdmin();
	$row->setFields(array("url"=>$furl,"title"=>$ftitle,"description"=>$fdescription,"categorie"=>$fcategorie));
	
	$mytable= new ND_Table();
	$mytable->setName("newtut");
	$mytable->setSqlQuery("select tid,T.description,T.title,T.url,categorie from $this->TABLE_NAME T,nuke_nd_tutorial_categories C Where T.CID=C.CID order  by date asc");
	$mytable->setDatabase($dbi);
	$mytable->setRow($row);
	$mytable->setBorder(1);
	$mytable->setHeader(array("Tutorial","Category","Function"));
		
	$mytable->setHeaderTag("align=\"center\" bgcolor=\"#BFCCDD\"");
	$mytable->setTableTag("WIDTH=\"98%\" BORDER=\"1\"");
	$mytable->show();	
	
}

/*********************************************************/
/* Acctept Tutorial Request                              */
/*********************************************************/

function AcceptTutorial($tid) {
	global $prefix, $dbi;
	$query="insert into nuke_nd_tutorials (cid,title,url,description,date) select cid,title,url,description,CURDATE() from nuke_nd_tutorials_request where tid=$tid";
	echo $query;
	sql_query($query, $dbi);
	$query="delete from nuke_nd_tutorials_request where tid=$tid";
	sql_query($query, $dbi);
	header("Location: admin.php?op=$this->ADMIN_LINK");
}

/*********************************************************/
/* insert Into DB                                       */
/*********************************************************/

function insertIntoDB() {
	global $title,$cid,$description,$url;
	global $prefix, $dbi;
	$url=htmlspecialchars($url);
	$query="insert into ".$prefix."_nd_tutorials (title,cid,description,date,url) values ('$title',$cid,'$description',CURDATE(),'$url')";
	sql_query($query, $dbi);
	header("Location: admin.php?op=$this->ADMIN_LINK");
}

/*********************************************************/
/* delete into DB                                        */
/*********************************************************/

function deleteIntoDB() {
	global $prefix, $dbi,$tid;
	$query="delete  from nuke_nd_tutorials where tid=$tid";
	sql_query($query, $dbi);
	header("Location: admin.php?op=$this->ADMIN_LINK");
}

/*********************************************************/
/* delete into DB                                        */
/*********************************************************/

function DeleteRequest($tid) {
	global $prefix, $dbi;
	$query="delete  from nuke_nd_tutorials_request where tid=$tid";
	sql_query($query, $dbi);
	header("Location: admin.php?op=$this->ADMIN_LINK");
}

	
/*********************************************************/
/* update DB                                             */
/*********************************************************/
function updateIntoDB() {
	global $prefix,$dbi;
	global $tid,$cid,$title,$url,$description;
	$url=htmlspecialchars($url);
	$query="update ".$prefix."_nd_tutorials set title='$title',cid=$cid,description='$description',url='$url' where tid=$tid";
	sql_query($query, $dbi);
	header("Location: admin.php?op=$this->ADMIN_LINK");
}

/*********************************************************/
/* Confirm Delete                                        */
/*********************************************************/

function confirmDelete($tid) {
 global $CST_TUTORIAL_DELETE_YES;
 
 include("header.php");
 GraphicAdmin();
 OpenTable();
 echo "<center>"._AUTHORDELSURE."<br>";
 echo " [ <A HREF=\"admin.php?op=$CST_TUTORIAL_DELETE_YES&tid=$tid\">"._YES."</A> ] - [ <A HREF=\"admin.php?op=$this->ADMIN_LINK\">"._NO."</A> ]</center>";
 CloseTable();
 include("footer.php");
}

/*********************************************************/
/* Switch Operation                                      */
/*********************************************************/

function switchOperation($op) {
global $CST_TUTORIALADD,$CST_TUTORIAL_INSERT_DB,$CST_TUTORIALEDIT,$CST_TUTORIAL_DELETE,$CST_TUTORIAL_DELETE_YES,$CST_TUTORIAL_UPDATE_DB;
global $tid;

switch ($op) {    
    
	case $CST_TUTORIALADD:
		include("header.php");
		GraphicAdmin();
		OpenTable();
		$this->showAdd();
		CloseTable();
		include("footer.php");
	break;
	
	case $CST_TUTORIAL_INSERT_DB:
	$this->insertIntoDB();
	break;
	
	case $CST_TUTORIALEDIT:
		include("header.php");
		GraphicAdmin();
		OpenTable();
		$this->showEdit();
		CloseTable();
		include("footer.php");
	break;
	
	case $CST_TUTORIAL_DELETE:
	$this->confirmDelete($tid);
	break;
	
	case $CST_TUTORIAL_DELETE_YES:
	$this->deleteIntoDB();
	break;
	 
	case $CST_TUTORIAL_UPDATE_DB:
	$this->updateIntoDB();
	break;
	
	case "accept":
		$this->AcceptTutorial($tid);
	break;
	
	case "deleteRequest":
		$this->DeleteRequest($tid);
	break;
}

}

}

?>