<?php
/*
 * $Id$
 *
 * Patch on module Topics, shows you some article headlines
 *
 * (c) Hinrich Donner, 2002
 */

/************************************************************************/
/* PHP-NUKE: Web Portal System                                          */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

/*
 * this defines how many headlines should be shown
 */
define('_HEADLINES_COUNT',      7);

if (!eregi("modules.php", $PHP_SELF)) {
    die ("You can't access this file directly...");
}

require_once 'mainfile.php';
$GLOBALS['index'] = 1;
$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$pagetitle = "- "._ACTIVETOPICS."";
include 'header.php';

OpenTable();
echo "<p align=\"center\"><span class=\"title\">"._ACTIVETOPICS."</span><br />\n"
    ."<span class=\"content\">"._CLICK2LIST."</span></p>\n";

$dbr = sql_query("SELECT topicid, topicname, topicimage, topictext
                  FROM ".$prefix."_topics
                  ORDER BY topicname", $dbi);

if (!$dbr || (sql_num_rows($dbr, $dbi) == 0))
{
    OpenTable2();
    echo ''._NO_TOPICS_AVAILABLE;
    CloseTable2();
}
else
{
    // beatify $tipath
    //
    $tipath = preg_replace("/([\/]+$)/", '', $tipath);

    $topics = array();
    while ($item = sql_fetch_array($dbr, $dbi))
    {
        $topics[] = $item;
    }
    $left_count = (int) (count($topics) / 2);
    $right_count = count($topics) - $left_count;

    echo "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"1\" border=\"0\">\n"
        ."<tr><td>";

    echo "<table width=\"100%\"  bgcolor=\"$bgcolor2\" cellpadding=\"3\" cellspacing=\"1\" border=\"0\">\n"
        ."<tr><td align=\"left\" valign=\"top\" width=\"50%\" bgcolor=\"$bgcolor3\"><span class=\"content\">";

    $language_sql = '';
    if ($multilingual == 1)
        $language_sql = "AND (`alanguage`='$currentlang' OR `alanguage`='')";

    for($i = 0; $i < count($topics); $i++)
    {
        if ($i == $left_count)
            echo "</span></td><td align=\"left\" valign=\"top\" width=\"50%\" bgcolor=\"$bgcolor3\"><span class=\"content\">";
        $topic =& $topics[$i];

        // First the topic information
        //
        $size = getImageSize("$tipath/$topic[topicimage]");
        echo "<a href=\"modules.php?name=News&amp;new_topic=$topic[topicid]\">"
            ."<img src=\"$tipath/$topic[topicimage]\" $size[3] alt=\"$topic[topictext]\" hspace=\"5\" vspace=\"5\" border=\"0\" align=\"right\" /></a>\n"
            ."<b>$topic[topictext]</b><br /><br />\n";

        $dbr = sql_query("SELECT `sid`, `title`, `time`, `aid`
                          FROM ".$prefix."_stories
                          WHERE (`topic`='$topic[topicid]' $language_sql)
                          ORDER BY `time` DESC
                          LIMIT 0,"._HEADLINES_COUNT, $dbi);
        if (!$dbr || (sql_num_rows($dbr, $dbi) == 0))
        {
            echo "<i>"._NO_ARTICLES_ON_THIS_TOPIC."</i><br />\n";
        }
        else
        {
            echo "<ul compact>";
            while ($article = sql_fetch_array($dbr, $dbi))
            {
                echo "<li><a href=\"modules.php?name=News&amp;file=article&amp;sid=$article[sid]\">$article[title]</a>"
                    ."<br /><small>(".strftime(''._TOPICS_DATE_FORMAT, strtotime($article['time'])).", $article[aid])</small></li>";
            }
            echo "</ul>\n"
                ."<div align=\"right\">"
                ."<a href=\"modules.php?name=News&amp;new_topic=$topic[topicid]\">"._READ_MORE."</a></div>";
        }
        echo "<br />\n";
        //echo $topic['topictext']."<br />";
    }
    echo "</span></td></tr></table></td></tr></table>\n";
}

echo "<p align=\"center\">\n"
    ."<span class=\"title\">"._SEARCH_AN_ARTICLE."</span><br /><br />\n"
    ."<span class=\"content\">"
    ."<form action=\"modules.php?name=Search\" method=\"post\">"
    ."<input type=\"name\" name=\"query\" size=\"30\">&nbsp;&nbsp;"
    ."<input type=\"submit\" value=\""._SEARCH."\">"
    ."</form></span></p>\n";
CloseTable();

include 'footer.php';

?>
