<?php

/************************************************************************/
/* PHP-NUKE: Web Portal System                                          */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2002 by Francisco Burzi                                */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (eregi("block-Sample_Block.php",$PHP_SELF)) {
    Header("Location: index.php");
    die();
}

/* This block converted for php-Nuke 6.0 by
 * Peter Pugh-Jones http://www.prpj.com
 * No credit required. 
 *
 * However please NOTE:
 *
 * Block code is from source code in file written by 
 * Martin Webster at http://spider-Monkey.net
 * 
 * Spider-Monkey license applies to this code
 * Please ensure that copyright is displayed 
 * as per license requirements at http://spider-Monkey.net/legal/
 * 
 * Original version phpnews-2.1.php Version 2.1 30/08/2002
 * This revision to php-Nuke 6.0 block 24/09/2002 

 *
 * This script will display the BBC News headlines from most of the BBC
 * News English language news pages (e.g. politics, sport,
 * sport | athletics etc.) and optionally summary text. Typically, the
 * script is incorporated into an existing Web page (.php) using
 * include('phpnews.php').
 *

 *
 * Change log.
 *
 * 2.1 New version (released as version 2.1 for comparison with the
 *                  BBC News retriever script).

 *
 * To do.
 *
 * 0. Optional images and related links. v2.1.1.
 * 1. Caching. v2.2.
 * 2. Error checking (incl. &formdata). v2.2.
 * 3. Configuration files -> alternative sites.
 * 4. OOD design -> integrate with your own code.
 *

 *
 * Copyright 2000-2002 Spider-Monkey.net, (Martin Webster). All rights
 * reserved. http://spider-monkey/legal/.
 *

 *
 * This program is provided by Martin Webster free of charge without
 * any warranty of any kind whatsoever. It is entirely your
 * responsibility to assess the suitability of this program for your
 * use. In using this program you accept responsibility for any damages
 * it may cause and agree to the terms of the Spider-Monkey Licence.
 */

/*
 * Functions (main program code follows this section).
 */

/*
 * This function fetches the remote file using PHP socket functions.
 */
 function fetch($domain, $port, $uri, $referer) {
  /*
   * Opens a dedicated connection to remotew site using specified port on
   * the host and returns a file pointer ($fp) suitable for use with
   * fputs() and fgets(). The '10' indicates timeout in seconds.
   */
   global $remote_file;
   $fp = fsockopen($domain, $port, $errno, $errstr, 10);

  /*
   * Simple error handling.
   */
   if (!$fp) {
     echo "$errstr ($errno)\n";
   } else {

    /*
     * Note that set_socket_blocking is depreciated and socket_set_blocking
     * is used. Blocking 'hangs' the script until there is some input to
     * return - turn this off.
     */
     socket_set_blocking($fp, FALSE);

    /*
     * Request the remote page, specify refering page (to ensure interstitial
     * isn't displayed, and give remote server somewhere to put a cookie.
     */
     fputs($fp, "GET $uri HTTP/1.0\r\n");
     fputs($fp, "Referer: $referer");
     fputs($fp, "Cookie: bbc.co.uk\r\n\r\n");

    /*
     * Read the remote file until end of file found. Also, ignore the HTTP
     * header, i.e. only place HTML in the scalar (converted to array later).
     */
     $header_start = FALSE;
     $header_end = FALSE;
     while (!feof($fp)) {
       $line = fgets($fp, 128);
       if ($header_end) {
         $remote_file .= $line;
       } else if (ereg("^HTTP", $line)) {
         $header_start = TRUE;
       } else if ($header_start && ereg("^[\n\r\t ]*$", $line)) {
         $header_end = TRUE;
       }
     }
     fclose($fp);
   }
 return $remote_file;
 }

/*
 * Return the text found between the two matched delimiters; that is,
 * patterns $p1 and $p2. The text returned is found in parenthesis.
 */
 function substring($code, $p1, $p2) {

 /*
  * Collect the string and delimiter patterns.
  */

 /*
  * Match the patterns.
  */
  ereg("$p1([^<>]*)$p2", $code, $match);
  return $match[1];
}

/*
 * Print header text.
 */
 
 function header_text($version, $title, $url) {
  /*
   *
   * In using this program you agree to leave the following text
   * intact. Please see the Spider-Monkey Licence
   * (http://spider-monkey.net/legal/licence.html).
   */
   $content .= "<!-- PHP News Retriever $version Copyright &copy; http://spider-monkey.net/, (Martin Webster).  All rights reserved -->";

  /*
   * You may change the following print statement. However, I strongly
   * urge you to retain a link back to the BBC News Web site.
   *
   * In a php-Nuke block below not look so good so commented, uncomment
   * if desired. 
   *
   * print "<a href=\"$url\" target=\"_blank\">$title</a><br /><br />";
   */
}

/*
 * Print footer text.
 */
 
  function footer_text($version) {
  /*
   * In using this program you agree to leave this text intact. Please
   * see the Spider-Monkey Licence
   * (http://spider-monkey.net/legal/licence.html).
   *
   * This information MUST be displayed, however think it okay if moved to 
   * footer of index page, is still within license permit.
   *  
   * Uncomment below if NOT displayed elsewhere on page.
   *
   *print "<p>PHP News Retriever $version.<br />Copyright &copy; 2000-2002
   *      <a href=\"http://spider-monkey.net/\" target=\"_blank\">Martin Webster</a>.</p>"
   */
   $content .= "     <!-- End of PHP News Retriever -->";
}

/*
 * Main program.
 */

/*
 * Declare variables.
 */

/*
 * Define global variables. For version 4.10 or later these can be
 * replaced with the new special variables:
 * $_GET;
 * $_POST; and
 * $_SERVER['REQUEST_METHOD'].
 * In all cases 'global $_GET;' etc. is not necessary!
 */
 global $REQUEST_METHOD, $HTTP_GET_VARS, $HTTP_POST_VARS;


/*
 * Version of the script.
 */
 $version = "2.1";

/*
 * Declare permitted name-value pairs and initialise the default
 * values. The script cannot use data that comes from outside the
 * script without untainting it first. Untainting verifies that the
 * data is valid (the serach pattern) before assigning it to a scalar
 * variable.
 */
 $list = 5;
 $concise = "no";
 $target = "_blank";
 $url = "http://news.bbc.co.uk/1/hi.html";

/*
 * Declare the default BBC News page attributes. Use /2/hi.html for
 * international news.
 */
 $domain= "news.bbc.co.uk";
 $port = 80;
 $protocol = "http";
 $referer = "http://news.bbc.co.uk/shared/hi/interstitial-news.stm";
 $uri = "/2/hi.html";

/*
 * Parse form data from form or link and place in an array. I found that
 * $REQUEST_METHOD did not work for PHP 4.10 so I've used both methods.
 */
   if ((strtolower($REQUEST_METHOD) == 'get') ||
       (strtolower($_SERVER['REQUEST_METHOD']) == 'get')) {
     $formdata = &$HTTP_GET_VARS;
   }elseif (strtolower($REQUEST_METHOD) == 'post') {
     $formdata = &$HTTP_POST_VARS;
   }
 

/*
 * Determine if summaries should be displayed.
 */
 if (isset($formdata['concise'])) {
   $tainted_data = $formdata['concise'];
   if (preg_match("/^(yes)$/", $tainted_data, $match)) {
     $concise = $match[1];
   }
 }

/*
 * Sets number of stories to be listed. Any positive number allowed;
 * 999 lists all.
 */
 if (isset($formdata['list'])) {
   $tainted_data = $formdata['list'];
   if (preg_match("/^(\d+)$/", $tainted_data, $match)) {
     $list = $match[1];
   }
 }

/*
 * Set the target attribute along with one of it's stated values to
 * specify how a linked document is to be opened into a browser window.
 */
 if (isset($formdata['target'])) {
   $tainted_data = $formdata['target'];
   if (preg_match("/^(_top|_blank|_new|_self)$/", $tainted_data, $match)) {
     $target = $match[1];
   }
 }

/*
 * Collect the servername and path (including full path). Note that
 * the protocol (e.g. http) is not required and is therefore ignored
 *  ($1).
 */
 if (isset($formdata['url'])) {
   $tainted_data = $formdata['url'];
   if (preg_match("#(\w+)://([^/:]+)(:\d+)?/(.*)#", $tainted_data, $match)) {
     $protocol = $match[1]; 
     $domain = $match[2]; 
     $uri = "/" . $match[4]; 
     if ($match[3]) {
       if (preg_match("/:(\d+)/", $match[3], $port)) {
         $port = $port[1];
       } else {
         $port = 80;
       }
     }
     $url = $protocol . "://" . $domain . ":" . $port . $uri;
   }
 }

/*
 *  The delimiter used to split the Web page into news story sections.
 * This must be plain text, i.e. no regular expressions.
 */
 $delimit = '<div class="bodytext">';

/*
 *  The regular expressions that delimit the URL of the full news
 * article.
 */
 $_url = array('begin' => '<a href="',
              'end' => '">+');

/*
 * The regular expressions that delimit each news headline.
 */
 $_headline = array('begin' => '<span class="h[1-3]+">{1}',
                   'end' => '</span>');

/*
 * The regular expressions that delimit the summary text for each news
 * item.
 */
 $_summary = array('begin' => '</span>{1}</a>{1}<br>{1}',
                 'end' => '<br clear=["]?(ALL|all)["]?>');

/*
 * Fetch the news page.
 */
 $result = explode("$delimit", fetch($domain, $port, $uri, $referer));

/*
 * Get the page title.
 */
 $title = substring($result[0], "<title>", "</title>");

/*
 * Print header text.
 */
 header_text($version, $title, $url);

/*
 * Find size of array, i.e. total number of stories.
 */
 if (($list == 999) || ($list > sizeof($result))) {
   $list = sizeof($result) - 1;
 }

/*
 * 
 */
 for ($i = 1; $i <= $list; $i++)
 {
  /*
   * Parse the URI (uniform resource identifier) for each story.
   */
   $url = substring($result[$i], $_url['begin'],
                                 $_url['end']);
 
  /*
   * Parse the headline text.
   */
   $headline = &substring($result[$i], $_headline{'begin'},
                                       $_headline{'end'});

  /*
   * Parse the summary text.
   */
   if ($concise != "yes") {
     $summary = trim(substring($result[$i], $_summary{'begin'},
                                            $_summary{'end'}));
     $summary .= "<br /><br />";
   } else {
     $summary  = "<br />";
   }

  /*
   * Print each story.
   * $content variable loaded here for php-Nuke block.
   */
   $content .= "<a href=\"$protocol://$domain$url\" 
   title=\"External link: $protocol://$domain$url\" target=\"$target\">
   $headline</a><br />$summary";
}

/*
 * Print footer text.
 */
 footer_text($version);

?>
